require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

MakeDialog
{
    Window
    {
        x=0,y=0,w=800,h=600,
        Bitmap
        {
            name="helppanel1",
            image="ui/surfaces/fullscreendialog",
            x=0,y=0,w=800,h=600,

			SetStyle(CreateTextStyle(FontGame, 32, RedColor)),
			Text
			{
				x=kCenter,y=10,w=kMax,h=40,
				flags = kVAlignCenter + kHAlignCenter,
				name = "helptitle",
				label= "helptitle",
			},

            --SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            --CreateText(0, kCenter + 280, "#"..GetString("version",GetConfig(kGameVersion)), 0, 0),

            --Jukebox
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0301",
                x = 100, y = 50,
                w=160,h=40,
            },
            
            --The Jukebox will increase the mood of people in line.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0301",
                x = 80, y = 70,
                w=200,h=100,
            },
            
            Bitmap
            {
				image="help/jukebox",
				x=140,y=110,
            },

            --Chili sauce
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0302",
                x = 510, y = 50,
                w=160,h=40,
            },
            
            --Chili sauce added to any plate will make the customer eat fast.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0302",
                x = 470, y = 70,
                w=240,h=100,
            },
            
            Bitmap
            {
				image="help/chili",
				x=560,y=110,
            },            

            --Coffee
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0304",
                x = 100, y = 330,
                w=160,h=40,
            },
            
            --Serve customers a cup of coffee while they are eating or ordering to increase their mood.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0304",
                x = 50, y = 350,
                w=260,h=100,
            },
            
            Bitmap
            {
				image="help/cofee",
				x=140,y=410,
            },

            --Dessert
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0305",
                x = 510, y = 330,
                w=160,h=40,
            },
            
            --Happier customers are more likely to order dessert.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0305",
                x = 500, y = 340,
                w=200,h=100,
            },
            
            Bitmap
            {
				image="help/desert",
				x=560,y=410,
            },            

            --Upgrades
            SetStyle(CreateTextStyle(FontHelp, 28, DarkRedColor)),
            Text
            {
                label="helpTopic0303",
                x = 310, y = 180,
                w=160,h=40,
            },
            
            --Purchase upgrades to improve the look of your restaurant and get better equipment to meet increasing customer demand.
            SetStyle(CreateTextStyle(FontHelp, 24, BlackColor)),
            Text
            {
                label="help0303",
                x = 250, y = 220,
                w=260,h=100,
            },

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="prev",
                align=kHAlignLeft+kVAlignBottom,
                x=40,y=kMax-10,
                command=
                    function()
                        SwapToModal("scripts/help2.lua");
                    end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"prev", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"prev", 0, 0),
            },
            
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="next",
                align=kHAlignRight+kVAlignBottom,
                x=kMax-40,y=kMax-10,
                command=function()
					SwapToModal("scripts/help4.lua");
				end,
		        SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		        CreateText(2,2,"next", 0, 0),
		        SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		        CreateText(0,0,"next", 0, 0),
            }
        },
    },
}
